#ifndef _CUSTOMGUI_IN_EXCLUDE_H_
#define _CUSTOMGUI_IN_EXCLUDE_H_

#include "customgui_base.h"
#include "c4d_basecontainer.h"
#include "c4d_gui.h"
#include "c4d_customdatatype.h"

class BaseDocument;

#define CUSTOMGUI_MATASSIGN						  200000026
#define CUSTOMDATATYPE_MATASSIGN				200000027

class MatAssignTable;

class MatAssignData : public iCustomDataType<MatAssignData>
{
private:
  MatAssignData();
public:

	void SetMaterial(const AtomArray &materials);
  Bool InsertObject(BaseList2D* pObject, LONG lFlags);
  Bool DeleteObject(BaseDocument *doc, BaseList2D* pObject) { return DeleteObject(GetObjectIndex(doc,pObject)); }

	Bool GetMaterial(BaseDocument *doc, AtomArray &materials);
  LONG GetObjectIndex(BaseDocument *doc, BaseList2D* pObject);
  LONG GetFlags(LONG lIndex);
  LONG GetFlags(BaseDocument *doc, BaseList2D* pObject) { return GetFlags(GetObjectIndex(doc,pObject)); }
  BaseContainer* GetData(LONG lIndex);
  BaseContainer* GetData(BaseDocument *doc, BaseList2D* pObject) { return GetData(GetObjectIndex(doc, pObject)); }
  BaseList2D* ObjectFromIndex(BaseDocument *doc, LONG lIndex);

  // returns a table that contains all included objects. Delete the list by calling FreeInclusionTable(table)
  // hierarchy_bit starts at 0
  MatAssignTable *BuildInclusionTable(BaseDocument *doc, LONG hierarchy_bit = NOTOK);

  Bool DeleteObject(LONG lIndex);
  LONG GetObjectCount();
};

class MatAssignTable
{
private:
  MatAssignTable();

public:
  Bool Check(BaseList2D *op);
  LONG GetObjectCount();
  BaseList2D* GetObject(LONG lIndex);
};

void FreeInclusionTable(MatAssignTable*& pTable);

class MatAssignCustomGui : public BaseCustomGui<CUSTOMGUI_MATASSIGN>
{
private:
	MatAssignCustomGui();
public:
};





// INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF
// INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF
// INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF


#ifndef _INTERNAL_DEF_
	class iMatAssignCustomGui : public iBaseCustomGui
	{
	};
  class iMatAssignData;
  class iMatAssignTable;
#else
	class iMatAssignCustomGui;
  class iMatAssignData;
  class iMatAssignTable;
#endif

struct CustomGuiMatAssignLib : public BaseCustomGuiLib
{
  Bool            (iMatAssignData::*InsertObject)(BaseList2D* pObject, LONG lFlags);
  LONG            (iMatAssignData::*GetObjectIndex)(BaseDocument *doc, BaseList2D* pObject);
  Bool            (iMatAssignData::*DeleteObject)(LONG lIndex);
  LONG            (iMatAssignData::*GetObjectCount)();
  BaseList2D*     (iMatAssignData::*ObjectFromIndex)(BaseDocument *doc, LONG lIndex);

  Bool            (iMatAssignTable::*Check)(BaseList2D *op);
  LONG            (iMatAssignTable::*GetObjectCountT)();
  BaseList2D*     (iMatAssignTable::*GetObject)(LONG lIndex);
  void            (*LIB_FreeInclusionTable)(iMatAssignTable *pTable);
  BaseContainer*  (iMatAssignData::*GetData)(LONG lIndex);
  void						(iMatAssignData::*SetMaterial)(const AtomArray &materials);
  Bool						(iMatAssignData::*GetMaterial)(BaseDocument *doc,AtomArray &materials);
};

// INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF
// INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF
// INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF

#endif // _CUSTOMGUI_IN_EXCLUDE_H_
